/*

 Character Script of the Sphere Community Game
 
 18 apr 2007 - inital version, Vincent van Beveren
 
 */

RequireScript('items.js');
Game.log.info('Initializing Characters...');

/**
 * Stat object is the basic object for statatistics.
 *
 * It has a main value, and optional a max.
 *
 * Parameters:
 *
 * value		The statistics value
 * max                  The maximum value, optional. If you don't specify a max
 *                      it has non and could in theory get very big.
 */
function Stat(value, max) {

	if (!max) {
		max = -1; // max = -1 means no max, only at initialization time
	}

	/**
	 * Sets the value of this stat. If the value is < 0 it becomes 0
	 * if the value is > max it becomes max.
	 */
	this.set = function(value) {
		if (value < 0) {
			value = 0;
		}
		if (this.maxValue >= 0 && value > this.maxValue) {
			value = this.maxValue;
		}
		this.value = value;
	}
	
	/**
	 * Gets the value of this stat.
	 */
	this.get = function() {
		return value;
	}
	
	/**
	 * sets the value of this stat. Throws an error is this object was created without stat support.
	 */
	this.setMax = function(maxValue) {
		if (this.maxValue == -1) {
			throw new Error('Stat does not have max value');
		}
		if (max < 0) {
			throw new Error('Stat.maxValue must be >= 0');
		}
		this.maxValue = maxValue;
		
		// check whether or not the maximum value still fits here.
		if (this.value > this.maxValue) {
			this.value = this.maxValue;
		}
	}
	
	/**
	 * Returns the max value of this stat.
	 */
	this.getMax = function() {
		return this.maxValue;
	}
	
	/**
	 * Increases the stat by the given amount. Values < 0 will decrease the stat.
	 */
	this.inc = function(delta) {
		this.set(this.get() + delta);
	}
	
	/**
	 * Decreases the stat by the given amount.
	 */
	this.dec = function(delta) {
		this.set(this.get() - delta);
	}
	
	/**
	 * Increases the max stat by the given amount. Values < 0 will decrease the max stat.
	 */
	this.incMax = function(delta) {
		this.setMax(this.getMax() + delta);
	}
	
	/**
	 * Decreases the max stat by the given amount.
	 */
	this.decMax = function(delta) {
		this.setMax(this.getMax() - delta);
	}
	
	
	this.toString = function() {
		if (this.maxValue >= 0) {
			return this.value + '/' + this.maxValue;
		} else {
			return this.value;
		}
	}
	
	this.maxValue = max;
	this.set(value);
}

/**
 * Stats is a collection of stats any character or game AI has.
 */
function Stats() {
	this.hp = new Stat(0, 0);
	this.mp = new Stat(0, 0);
	this.ap = new Stat(0, 0);
	this.dp = new Stat(0, 0);
	this.sp = new Stat(0, 0);	
	this.accuracy = new Stat(0);
	this.reaction = new Stat(0);
	this.range = new Stat(0);
	this.crisis = new Stat(0);
}


/**
 * Character controls an ingame character, which can be the player, a friend or a foe.
 */
function Character(name) {
	this.name = name;
	this.stats = new Stats();
}
